close all

% % Import
load('rec1_001.mat') %singolo modello, 0.2 timestep, ode1be, 0.1 weight compressor, 0.5 deltau
load('rec1_004.mat') %modello doppio, 0.2 timestep per il plant e ode1be, 0.01 e ode4 per il controller, 0.1 weight compressor, 0.5deltau
load('rec1_002_2model_ode1be.mat')  %modello doppio, 0.2 timestep per il plant e ode1be, 0.01 e ode1be per il controller, 0.1 weight compressor, 0.5deltau

load('rec1_011.mat') %CAN, 0.2 controller e plant, 0.2 bus controller e CAN, 10 priority config, 40 periodic task
load('rec1_021.mat') %Full run of the one above
load('rec1_029.mat') %Run with new compressor to be associated with the matlab run of the New compressor

%% Comparation of various results with Simulink results

close all

% % Import dei file
rec_files = {'rec1_001.mat', 'rec1_004.mat', 'rec1_002_2model_ode1be.mat', 'rec1_029.mat'};
% % Lo 0_29 va fatto con l'altro modello simulink, lo 0_11 è incompleto


% % Creo un file con tutti gli rms errors
rms_errors = struct();

for i = 1:length(rec_files)
    % Caricamento dinamico dei dati
    load(rec_files{i});
    rec_data = eval(strrep(rec_files{i}, '.mat', ''));

    % Estrazione dati
    cmd_comp_dspace = rec_data.Y(1).Data;
    EPower_compressor_dspace = rec_data.Y(2).Data;
    T_battery_dspace = rec_data.Y(3).Data;

    % Allineamento temporale
    if i == 4

    cmd_comp_dspace = rec_data.Y(3).Data;
    EPower_compressor_dspace = rec_data.Y(1).Data;
    T_battery_dspace = rec_data.Y(2).Data;

    EPower_Compressor_aligned = interp1(out.EPower_Compressor.time, out.EPower_Compressor.signals.values, rec_data.X(1).Data, 'linear', 'extrap');
    cmd_comp_aligned = interp1(out.EPower_Compressor.time, out.cmd_comp.signals.values, rec_data.X(1).Data, 'linear', 'extrap');
    T_battery_aligned = interp1(out.EPower_Compressor.time, out.T_battery1.signals.values, rec_data.X(1).Data, 'linear', 'extrap');

    %% Here I find the offset by correlation
    [corr_off, lag_off] = xcorr(EPower_compressor_dspace,EPower_Compressor_aligned,'coeff');
    [~, index_off] = max(corr_off);
    offset = lag_off(index_off);

    EPower_compressor_dspace_aligned = circshift(EPower_compressor_dspace, -offset);
    cmd_comp_dspace_aligned = circshift(cmd_comp_dspace, -offset);  
    T_battery_dspace_aligned = circshift(T_battery_dspace, -offset);  

    % Plot dei risultati
    figure;
    subplot(3, 1, 1);
    plot(rec_data.X(1).Data, EPower_compressor_dspace_aligned, 'LineWidth', 2);
    hold on;
    plot(rec_data.X(1).Data, EPower_Compressor_aligned, 'LineWidth', 2);
    xlabel('Time');
    ylabel('EPower Compressor');
    legend('dSpace', 'Simulink');
    title(['Comparison for ', rec_files{i}]);

    subplot(3, 1, 2);
    plot(rec_data.X(1).Data, cmd_comp_dspace_aligned, 'LineWidth', 2);
    hold on;
    plot(rec_data.X(1).Data, cmd_comp_aligned, 'LineWidth', 2);
    xlabel('Time');
    ylabel('Command Compressor');
    legend('dSpace', 'Simulink');

    subplot(3, 1, 3);
    plot(rec_data.X(1).Data, T_battery_dspace_aligned, 'LineWidth', 2);
    hold on;
    plot(rec_data.X(1).Data, T_battery_aligned, 'LineWidth', 2);
    xlabel('Time');
    ylabel('Battery Temperature');
    legend('dSpace', 'Simulink');

    else
     
    EPower_Compressor_aligned = interp1(out.EPower_Compressor.time, out.EPower_Compressor.signals.values, rec_data.X.Data, 'linear', 'extrap');
    cmd_comp_aligned = interp1(out.EPower_Compressor.time, out.cmd_comp.signals.values, rec_data.X.Data, 'linear', 'extrap');
    T_battery_aligned = interp1(out.EPower_Compressor.time, out.T_battery1.signals.values, rec_data.X.Data, 'linear', 'extrap');
    
    %% Here I find the offset by correlation
    [corr_off, lag_off] = xcorr(EPower_compressor_dspace,EPower_Compressor_aligned,'coeff');
    [~, index_off] = max(corr_off);
    offset = lag_off(index_off);

    EPower_compressor_dspace_aligned = circshift(EPower_compressor_dspace, -offset);
    cmd_comp_dspace_aligned = circshift(cmd_comp_dspace, -offset);  % applica lo stesso offset agli altri segnali
    T_battery_dspace_aligned = circshift(T_battery_dspace, -offset);  % applica lo stesso offset agli altri segnali


    % Plot dei risultati
    figure;
    subplot(3, 1, 1);
    plot(rec_data.X.Data, EPower_compressor_dspace_aligned, 'LineWidth', 2);
    hold on;
    plot(rec_data.X.Data, EPower_Compressor_aligned, 'LineWidth', 2);
    xlabel('Time');
    ylabel('EPower Compressor');
    legend('dSpace', 'Simulink');
    title(['Comparison for ', rec_files{i}]);

    subplot(3, 1, 2);
    plot(rec_data.X.Data, cmd_comp_dspace_aligned, 'LineWidth', 2);
    hold on;
    plot(rec_data.X.Data, cmd_comp_aligned, 'LineWidth', 2);
    xlabel('Time');
    ylabel('Command Compressor');
    legend('dSpace', 'Simulink');

    subplot(3, 1, 3);
    plot(rec_data.X.Data, T_battery_dspace_aligned, 'LineWidth', 2);
    hold on;
    plot(rec_data.X.Data, T_battery_aligned, 'LineWidth', 2);
    xlabel('Time');
    ylabel('Battery Temperature');
    legend('dSpace', 'Simulink');

    end

    % Calcolo degli errori RMSE
    rms_errors(i).file = rec_files{i};
    rms_errors(i).err_pow = sqrt(mean((EPower_compressor_dspace - EPower_Compressor_aligned).^2));
    rms_errors(i).err_cmd = sqrt(mean((cmd_comp_dspace - cmd_comp_aligned).^2));
    rms_errors(i).err_temp = sqrt(mean((T_battery_dspace - T_battery_aligned).^2));

    % Visualizzazione errori per file
    fprintf('File: %s\n', rms_errors(i).file);
    fprintf('  RMSE Power: %.3f\n', rms_errors(i).err_pow);
    fprintf('  RMSE Command: %.3f\n', rms_errors(i).err_cmd);
    fprintf('  RMSE Temperature: %.3f\n', rms_errors(i).err_temp);
    disp('--------------------------------');
end
